/**
  ******************************************************************************
  * File Name          : gpio.c
  * Description        : This file provides code for the configuration
  *                      of all used GPIO pins.
  ******************************************************************************
  */

/* Includes ------------------------------------------------------------------*/
#include "gpio.h"
/* USER CODE BEGIN 0 */

/* USER CODE END 0 */

/*----------------------------------------------------------------------------*/
/* Configure GPIO                                                             */
/*----------------------------------------------------------------------------*/
/* USER CODE BEGIN 1 */

/* USER CODE END 1 */

/** Configure pins as 
        * Analog 
        * Input 
        * Output
        * EVENT_OUT
        * EXTI
        * Free pins are configured automatically as Analog (this feature is enabled through 
        * the Code Generation settings)
*/
void GPIO_Init(void)
{
/*
  CKCU_PeripClockConfig_TypeDef CKCUClock = {{ 0 }};
  CKCUClock.Bit.EXTI       = 1;
  CKCUClock.Bit.SPI1       = 1;
  CKCUClock.Bit.PA         = 1;
  CKCUClock.Bit.PB         = 1;
  CKCUClock.Bit.AFIO       = 1;
	CKCUClock.Bit.UART1			 = 1;
  CKCU_PeripClockConfig(CKCUClock, ENABLE);
*/

	//TEST PIN
  //GPIO_SetOutBits(HT_GPIOB, GPIO_PIN_0);
  //AFIO_GPxConfig(GPIO_PB, GPIO_PIN_0, AFIO_MODE_DEFAULT);
  //GPIO_DirectionConfig(HT_GPIOB, GPIO_PIN_0, GPIO_DIR_OUT);
	
  /*Configure GPIO pin Output Level */
  GPIO_ClearOutBits(SPI_SEL, SPI_SEL_PIN);
  GPIO_ClearOutBits(LED_GREEN_GPIO_Port, LED_GREEN_Pin);
  GPIO_ClearOutBits(LED_RED_GPIO_Port, LED_RED_Pin);


	/*Configure GPIO pin : IRQ pin */
   AFIO_GPxConfig(BC45_IRQ_GPIO_ID, BC45_IRQ_Pin, AFIO_FUN_GPIO);
	GPIO_DirectionConfig(BC45_IRQ_GPIO_Port, BC45_IRQ_Pin, GPIO_DIR_IN);
	GPIO_PullResistorConfig(BC45_IRQ_GPIO_Port, BC45_IRQ_Pin, GPIO_PR_DOWN);
	GPIO_InputConfig(BC45_IRQ_GPIO_Port, BC45_IRQ_Pin, ENABLE);


	/*Configure GPIO pin : NCS pin */
  AFIO_GPxConfig(SPI_SEL_ID, SPI_SEL_PIN, SPI_SEL_AFIO_MODE);
  GPIO_DirectionConfig(SPI_SEL, SPI_SEL_PIN, GPIO_DIR_OUT);


  AFIO_GPxConfig(BC45_RSTPD_GPIO_ID, BC45_RSTPD_Pin, SPI_SEL_AFIO_MODE);
	GPIO_ClearOutBits(BC45_RSTPD_GPIO_Port, BC45_RSTPD_Pin);
  GPIO_DirectionConfig(BC45_RSTPD_GPIO_Port, BC45_RSTPD_Pin, GPIO_DIR_OUT);

/*Configure GPIO pins : PBPin PBPin PBPin PBPin 
                           PBPin PBPin */
  AFIO_GPxConfig(LED_GREEN_GPIO_ID, LED_GREEN_Pin, AFIO_FUN_GPIO);
  AFIO_GPxConfig(LED_RED_GPIO_ID, LED_RED_Pin, AFIO_FUN_GPIO);

  GPIO_DirectionConfig(LED_GREEN_GPIO_Port, LED_GREEN_Pin, GPIO_DIR_OUT);
  GPIO_DirectionConfig(LED_RED_GPIO_Port, LED_RED_Pin, GPIO_DIR_OUT);  
	
	
  AFIO_GPxConfig(GPIO_PA, GPIO_PIN_7, AFIO_MODE_DEFAULT);
  GPIO_DirectionConfig(HT_GPIOA, GPIO_PIN_7, GPIO_DIR_OUT);
	GPIO_ClearOutBits(HT_GPIOA, GPIO_PIN_7);
	
	InitBC45_IRQ();
}

/* USER CODE BEGIN 2 */

/*
  * @brief  Set SPI NCS pin.
  * @param  None
  * @retval None
 * */
#if 0
void BC45_SPI_NCS_SET(void)
{
	CKCU_PeripClockConfig_TypeDef CKCUClock = {{0}};

	/* Enable the PA Clock                                                                                */
	CKCUClock.Bit.PA       = 1;
	CKCU_PeripClockConfig(CKCUClock, ENABLE);

	/*Configure GPIO pin : NCS pin */
  AFIO_GPxConfig(SPI_SEL_ID, SPI_SEL_PIN, SPI_SEL_AFIO_MODE);
	/*Set NCS pin to high (Unselect)*/
  GPIO_SetOutBits(SPI_SEL, SPI_SEL_PIN);
  GPIO_DirectionConfig(SPI_SEL, SPI_SEL_PIN, GPIO_DIR_OUT);

	CKCU_PeripClockConfig(CKCUClock, DISABLE);
}
#endif


/**
  * @brief  Initial B45 pin be interrupt.
  * @param  None
  * @retval None
  */
void InitBC45_IRQ(void)
{
    EXTI_InitTypeDef EXTI_InitStruct = {0};

    /* Connect Button EXTI Channel to Button GPIO Pin                                                       */
    AFIO_EXTISourceConfig((AFIO_EXTI_CH_Enum)BC45_IRQ_EXTI_IRQn, (AFIO_ESS_Enum)BC45_IRQ_GPIO_ID);
    NVIC_EnableIRQ(EVWUP_IRQn);
		EXTI_WakeupEventIntConfig(ENABLE);
}

void EnableBC45_IRQ(void)
{
	EXTI_WakeupEventConfig(BC45_IRQ_EXTI_IRQn, EXTI_WAKEUP_HIGH_LEVEL, ENABLE);	
}

void DisableBC45_IRQ(void)
{
	EXTI_WakeupEventConfig(BC45_IRQ_EXTI_IRQn, EXTI_WAKEUP_HIGH_LEVEL, DISABLE);
}

/**
  * @brief  Initial BC45 connected GPIO.
  * @param  None
  * @retval None
  */
#if 0
void InitBC45_GPIO_Pin(void)
{
	#if 0
  CKCU_PeripClockConfig_TypeDef CKCUClock = {{ 0 }};
  CKCUClock.Bit.PA         = 1;
  CKCUClock.Bit.PB         = 1;
  CKCUClock.Bit.AFIO       = 1;
  CKCU_PeripClockConfig(CKCUClock, ENABLE);
	#endif


	/*Configure GPIO pin : IRQ pin */
  AFIO_GPxConfig(BC45_IRQ_GPIO_ID, BC45_IRQ_Pin, AFIO_FUN_GPIO);
	GPIO_DirectionConfig(BC45_IRQ_GPIO_Port, BC45_IRQ_Pin, GPIO_DIR_IN);
	GPIO_InputConfig(BC45_IRQ_GPIO_Port, BC45_IRQ_Pin, ENABLE);
	//GPIO_PullResistorConfig(BC45_IRQ_GPIO_Port, BC45_IRQ_Pin, GPIO_PR_DOWN);
	//GPIO_PullResistorConfig(BC45_IRQ_GPIO_Port, BC45_IRQ_Pin, GPIO_PR_DISABLE);

	/*Configure GPIO pin : NCS pin */
  AFIO_GPxConfig(SPI_SEL_ID, SPI_SEL_PIN, SPI_SEL_AFIO_MODE);
	/*Set NCS pin to high (Unselect)*/
  GPIO_SetOutBits(SPI_SEL, SPI_SEL_PIN);
  GPIO_DirectionConfig(SPI_SEL, SPI_SEL_PIN, GPIO_DIR_OUT);	
}
#endif

/**
  * @brief  Disable all peripheral of HT32F52241
  * @param  None
  * @retval None
  */
void DisableAllPeripheral(void)
{
	#if 0
  CKCU_PeripClockConfig_TypeDef CKCUClock = {{ 0 }};
  CKCUClock.Bit.EXTI       = 1;
  CKCUClock.Bit.SPI1       = 1;
  CKCUClock.Bit.PA         = 1;
  CKCUClock.Bit.PB         = 1;
  CKCUClock.Bit.AFIO       = 1;
	CKCUClock.Bit.UART1			 = 1;
  CKCU_PeripClockConfig(CKCUClock, ENABLE);
	#endif

  GPIO_DirectionConfig(SPI_SEL, SPI_SEL_PIN, GPIO_DIR_IN);
  GPIO_PullResistorConfig(SPI_SEL, SPI_SEL_PIN, GPIO_PR_UP);
	GPIO_InputConfig(SPI_SEL, SPI_SEL_PIN, ENABLE);
  
  GPIO_DirectionConfig(LED_GREEN_GPIO_Port, LED_GREEN_Pin, GPIO_DIR_IN);
  GPIO_PullResistorConfig(LED_GREEN_GPIO_Port, LED_GREEN_Pin, GPIO_PR_UP);
	GPIO_InputConfig(LED_GREEN_GPIO_Port, LED_GREEN_Pin, ENABLE);

  GPIO_DirectionConfig(LED_RED_GPIO_Port, LED_RED_Pin, GPIO_DIR_IN);  
  GPIO_PullResistorConfig(LED_RED_GPIO_Port, LED_RED_Pin, GPIO_PR_UP);
	GPIO_InputConfig(LED_RED_GPIO_Port, LED_RED_Pin, ENABLE);


  //CKCU_PeripClockConfig(CKCUClock, DISABLE);
}


/**
  * @brief  Initial UART3 PIN and clock
  * @param  None
  * @retval None
  */
void InitUart_Pin(void)
{
	#if 0
  CKCU_PeripClockConfig_TypeDef CKCUClock = {{ 0 }};
  CKCUClock.Bit.PA        = 1;
	CKCUClock.Bit.UART1			= 1;
  CKCU_PeripClockConfig(CKCUClock, ENABLE);
	#endif
	
  /* Config AFIO mode as COM1_Rx and COM1_Tx function.                                                      */
  AFIO_GPxConfig(COM1_TX_GPIO_ID, COM1_TX_AFIO_PIN, AFIO_FUN_USART_UART);
  AFIO_GPxConfig(COM1_RX_GPIO_ID, COM1_RX_AFIO_PIN, AFIO_FUN_USART_UART);

  USART_TxCmd(COM1_PORT, ENABLE);
  USART_RxCmd(COM1_PORT, ENABLE);
}


/**
  * @brief  Disable all peripheral of HT32F52241
  * @param  None
  * @retval None
  */
void InitSPI_Pin(void)
{
  /**SPI1 GPIO Configuration
  PA0     ------> SPI1_SCK
  PA1     ------> SPI1_MISO
  PA2     ------> SPI1_MOSI
  */
  /*  Configure SPI SEL                                                                                 	*/
  AFIO_GPxConfig(SPI_SEL_ID, SPI_SEL_PIN, SPI_SEL_AFIO_MODE);
  GPIO_SetOutBits(SPI_SEL, SPI_SEL_PIN);
  GPIO_DirectionConfig(SPI_SEL, SPI_SEL_PIN, GPIO_DIR_OUT);
	GPIO_InputConfig(SPI_SEL, SPI_SEL_PIN, DISABLE);
  
  /*  Configure SPI SCK pin, SPI MISO pin, SPI MOSI pin                                                     */
  AFIO_GPxConfig(SPI_SCK_ID, SPI_SCK_PIN, SPI_SCK_AFIO_MODE);
  AFIO_GPxConfig(SPI_MISO_ID, SPI_MISO_PIN, SPI_MISO_AFIO_MODE);
  AFIO_GPxConfig(SPI_MOSI_ID, SPI_MOSI_PIN, SPI_MOSI_AFIO_MODE);
	
  GPIO_PullResistorConfig(SPI_MISO, SPI_MISO_PIN, GPIO_PR_UP);
	
	SPI_Cmd(BC45_SPI, ENABLE);
}

/**
  * @brief  Initial LED pin.
  * @param  None
  * @retval None
  */
void InitLED_GPIO_Pin(void)
{
	#if 0
  CKCU_PeripClockConfig_TypeDef CKCUClock = {{ 0 }};
  CKCUClock.Bit.PB         = 1;
  CKCU_PeripClockConfig(CKCUClock, ENABLE);
	#endif
	
  /*  Configure SPI SEL & HOLD pin                                                                                 */
  AFIO_GPxConfig(LED_GREEN_GPIO_ID, LED_GREEN_Pin, AFIO_FUN_GPIO);
  AFIO_GPxConfig(LED_RED_GPIO_ID, LED_RED_Pin, AFIO_FUN_GPIO);

  GPIO_SetOutBits(LED_GREEN_GPIO_Port, LED_GREEN_Pin);
  GPIO_SetOutBits(LED_RED_GPIO_Port, LED_RED_Pin);

  GPIO_DirectionConfig(LED_GREEN_GPIO_Port, LED_GREEN_Pin, GPIO_DIR_OUT);
  GPIO_DirectionConfig(LED_RED_GPIO_Port, LED_RED_Pin, GPIO_DIR_OUT);  

	GPIO_InputConfig(LED_GREEN_GPIO_Port, LED_GREEN_Pin, DISABLE);
	GPIO_InputConfig(LED_RED_GPIO_Port, LED_RED_Pin, DISABLE);
}


void SPI1_Init(void)
{
  SPI_InitTypeDef  SPI_InitStructure;

	/*  SPI Configuration                                                                                     */
  SPI_InitStructure.SPI_Mode = SPI_MASTER;
  SPI_InitStructure.SPI_FIFO = SPI_FIFO_DISABLE;
  SPI_InitStructure.SPI_DataLength = SPI_DATALENGTH_8;
  SPI_InitStructure.SPI_SELMode = SPI_SEL_SOFTWARE;
  SPI_InitStructure.SPI_SELPolarity = SPI_SELPOLARITY_LOW;
  SPI_InitStructure.SPI_FirstBit = SPI_FIRSTBIT_MSB;
  SPI_InitStructure.SPI_CPOL = SPI_CPOL_LOW;
  SPI_InitStructure.SPI_CPHA = SPI_CPHA_FIRST;
  SPI_InitStructure.SPI_RxFIFOTriggerLevel = 0;
  SPI_InitStructure.SPI_TxFIFOTriggerLevel = 0;
  SPI_InitStructure.SPI_ClockPrescaler = 8;
  SPI_Init(BC45_SPI, &SPI_InitStructure);
  SPI_SELOutputCmd(BC45_SPI, ENABLE);

	InitSPI_Pin();
}

void SPI1_DeInit(void)
{
  SPI_SELOutputCmd(BC45_SPI, DISABLE);
  SPI_Cmd(BC45_SPI, DISABLE);
	
  /*  Configure SPI SCK pin, SPI MISO pin, SPI MOSI pin                                                     */
  AFIO_GPxConfig(SPI_SCK_ID, SPI_SCK_PIN, AFIO_MODE_DEFAULT);
  AFIO_GPxConfig(SPI_MISO_ID, SPI_MISO_PIN, AFIO_MODE_DEFAULT);
  AFIO_GPxConfig(SPI_MOSI_ID, SPI_MOSI_PIN, AFIO_MODE_DEFAULT);		

  /*  Configure SPI SEL                                                                                 */
  //GPIO_DirectionConfig(SPI_SEL, SPI_SEL_PIN, GPIO_DIR_IN);
}

void USART1_DeInit()
{
  AFIO_GPxConfig(COM1_TX_GPIO_ID, COM1_TX_AFIO_PIN, AFIO_FUN_GPIO);
  AFIO_GPxConfig(COM1_RX_GPIO_ID, COM1_RX_AFIO_PIN, AFIO_FUN_GPIO);

  /* Enable COM1_PORT                                                                                       */
  USART_TxCmd(COM1_PORT, DISABLE);
  USART_RxCmd(COM1_PORT, DISABLE);
}

/* USER CODE END 2 */

/**
  * @}
  */

/**
  * @}
  */

